<?Lassoscript
// Last modified: 1/15/07 by ECL, Landmann InterActive
// Prepared for Lasso Summit 07

// FUNCTIONALITY
// Issue form

// Convert action_params
// Convert ID and Process for Edit page
If: (Response_Filepath) >> 'bugs_editrecord.lasso' ||  (Response_Filepath) >> 'bugs_addresponse.lasso';
	Var:'vBug_ID' = '';
	Var:'vBug_ID' = (Action_Param:'BugID');
	Var:'vProcess' = (Action_Param:'Process');
	Var:'vAction' = (Action_Param:'Action');
/If;

Include:'bugs_params.inc';

// If Edit page, get the record
If: (Response_Filepath) >> 'bugs_editrecord.lasso';
	// If Process = Y, form was submit, so update the record
	// Otherwise, it is a new edit so get the record
	If: $vProcess != 'Y';
		// Get the record
		Var:'vSQLSearchBugs'='SELECT *
			FROM ' $svBugsTable ' WHERE Bug_ID = "'($vBug_ID)'" LIMIT 1';
		Inline: $IV_SearchBugs, -SQL=$vSQLSearchBugs;
			// If Found_Count is wrong, the wrong ID was passed, so dump out 2000 "No Record Found"	
			If: (Found_Count) == 0;
				Var:'vError' = '2000';
				Show_Error: -ErrNum=(Var:'vError'), -Option=(Var:'vOption'), -PosColor='00CC00', -NegColor='FF0000', -BgColor='F0F1F1';
				Abort;
			/If;
			Var:'vTitle'=(Field:'Title');
			Var:'vDescription'=(Field:'Description');
			Var:'vProject_ID'=(Field:'Project_ID');
			Var:'vVersion_ID'=(Field:'Version_ID');
			Var:'vSeverity_ID'=(Field:'Severity_ID');
			Var:'vURL'=(Field:'URL');
			Var:'vPriority_ID'=(Field:'Priority_ID');
			Var:'vStatus_ID'=(Field:'Status_ID');
			Var:'vResolution_ID'=(Field:'Resolution_ID');
			Var:'vAssigned_To'=(Field:'Assigned_To');
			Var:'vCreated_By'=(Field:'Created_By');
			Var:'vLastModified_By' = Field:'LastModified_By';
			Var:'vOS_ID'=(Field:'OS_ID');
			Var:'vBrowser_ID'=(Field:'Browser_ID');
			Var:'vClosedInVers_ID'=(Field:'ClosedInVers_ID');
			Var:'vToBeClosedVers_ID'=(Field:'ToBeClosedVers_ID');
			Var:'vDateCreated' = Field:'DateCreated';
			Var:'vDateModified' = Field:'DateModified';
		/Inline;
	Else;
		// Update the record
		Inline: $IV_UpdateBugs, 'Bug_ID' = $vBug_ID;
			// If there is an error, dump out error 1012 "Update Failed"
			If: (Error_CurrentError) != 0;
				Var:'vError' = '1012';
			/If;
		/Inline;
	/If;
	
/If;

// Get Reported_By's user name
Var:'SQLSearchUsers' = 'SELECT User_FName, User_LName, User_ID FROM ' $svUsersTable ' WHERE User_ID = "' $vCreated_By '" LIMIT 1';
	Inline: $IV_SearchUsers,-SQL=$SQLSearchUsers;
		Records;
			Var:'ReportedByLabel' = (Field:'User_FName') ' ' (Field:'User_LName');
		/Records;
	/Inline;

If: (Var:'vBug_ID') == '';
	'<h2>Issue Report</h2>\n';
Else;
	'<h2>Issue # ' (Var:'vBug_ID') '</b> - ' $vTitle '</h2>\n';
/If;
?>
<?Lassoscript

// Standard Error Table
If: (Var:'vError') != '';
	Show_Error: -ErrNum=(Var:'vError'), -Option=(Var:'vOption'), -PosColor='00CC00', -NegColor='FF0000', -BgColor='F0F1F1';
/If;
?> 

<form action="bugs_addresponse.lasso" method="post">
	<table border="0" cellpadding="5" width="520">
[If: (Response_Filepath) >> 'bugs_editrecord.lasso']
		<tr>
			<td width="120" bgcolor="#666666">
				<div align="right">
					<font color="#FFFFFF"><b>Date</b></font>
				</div>
			</td>
			<td valign="top" bgcolor="#cccccc">
				[Var:'vDateCreated']
			</td>
		</tr>
[/If]
		<tr>
			<td width="120" bgcolor="#666666">
				<div align="right">
					<font color="#FFFFFF"><b>Reported By</b></font>
				</div>
			</td>
			<td valign="top" bgcolor="#cccccc">
				[Var:'SQLSearchUsers' = 'SELECT User_FName, User_LName, User_ID FROM ' $svUsersTable '
				WHERE User_ID = "' $vCreated_By '" LIMIT 1']
				[Inline: $IV_SearchUsers,-SQL=$SQLSearchUsers]
					[Records]
						[Field:'User_FName'] [Field:'User_LName']
					[/Records]
		        [/Inline]
			</td>
		</tr>
<?Lassoscript
// If an add page, display a popup and the "required field" marker, otherwise output the field
?>
		<tr>
			<td width="120" bgcolor="#666666">
				<div align="right">
					<font color="#FFFFFF"><b>Project</b></font>[If: (Response_Filepath) >> 'bugs_add.lasso'][$svInputRequired][/If]
				</div>
			</td>
<?Lassoscript
// If an add page, display a popup and the "required field" marker, otherwise output the field
If: (Response_Filepath) >> 'bugs_add.lasso'; ?>
			<td valign="top" bgcolor="#cccccc">
<?Lassoscript
// Get Project info
Var:'SQLSearchProjects' =
	'SELECT DISTINCT(lbt_project.project_ID),
		lbt_users2groups.User_ID,
		lbt_project.project_Name, lbt_project.project_status
	FROM lbt_users2groups
	LEFT JOIN lbt_groups2projects ON lbt_users2groups.group_ID = lbt_groups2projects.group_ID
	LEFT JOIN lbt_project ON lbt_project.project_ID = lbt_groups2projects.project_ID
	WHERE lbt_users2groups.User_ID = "' ($svUser_ID) '"
	AND lbt_project.project_status != "Inactive"
	ORDER BY lbt_project.project_Name';

	Inline: $IV_SearchProjects,-SQL=$SQLSearchProjects;

		// If no projects found, output a "No projects found!" message
		If: (Found_Count) == 0;
			'\t\t\t\t<p class="alert">No projects found! Please create a project.</p>\n';
		Else;
?>				<select name="Project_ID">
					<option value=""[If: (Var:'vProject_ID') == ''] selected[/If]></option>
					[Records]
					<option value="[Field:'Project_ID']"[If: (Var:'vProject_ID') == (Field:'Project_ID')] selected[/If]>[Field:'Project_Name']</option>
					[/Records]
		        </select>
		[/If]
	[/Inline]
			</td>
[Else]
			<td valign="top" bgcolor="#cccccc">
				[Var:'SQLSearchProjects' = 'SELECT * FROM ' $svProjectsTable ' WHERE project_ID = "' $vProject_ID '"']
				[Inline: $IV_SearchProjects,-SQL=$SQLSearchProjects]
					<b>[Field:'Project_Name']</b>
		        [/Inline]
			</td>
		</tr>
[/If]
		<tr>
			<td width="120" bgcolor="#666666">
				<div align="right">
					<font color="#FFFFFF"><b>Version</b></font>[$svInputRequired]
				</div>
			</td>
			<td valign="top" bgcolor="#cccccc">
				[Var:'SQLSearchVersions' = 'SELECT * FROM ' $svVersionsTable ' WHERE version_status = "Active" AND wg_id = "' $svUser_WGID '" ORDER BY version_name ASC']
				[Inline: $IV_SearchVersions,-SQL=$SQLSearchVersions]
				<select name="Version_ID">
					<option value=""[If: (Var:'vVersion_ID') == ''] selected[/If]></option>
					[Records]
					<option value="[Field:'Version_ID']"[If: (Var:'vVersion_ID') == (Field:'Version_ID')] selected[/If]>[Field:'Version_Name']</option>
					[/Records]
		        </select>
		        [/Inline]
			</td>
		</tr>
		<tr>
			<td width="120" bgcolor="#666666">
				<div align="right">
					<font color="#FFFFFF"><b>To be Closed in Version</b></font>
				</div>
			</td>
			<td valign="top" bgcolor="#cccccc">
				[Inline: $IV_SearchVersions,-SQL=$SQLSearchVersions]
				<select name="ToBeClosedVers_ID">
					<option value=""[If: (Var:'vToBeClosedVers_ID') == ''] selected[/If]></option>
					[Records]
					<option value="[Field:'Version_ID']"[If: (Var:'vToBeClosedVers_ID') == (Field:'Version_ID')] selected[/If]>[Field:'Version_Name']</option>
					[/Records]
		        </select>
		        [/Inline]
			</td>
		</tr>
<?Lassoscript
// If Add page, do not display "Closed in Version"
If: !((Response_Filepath) >> 'bugs_add.lasso');
?>
		<tr>
			<td width="120" bgcolor="#666666">
				<div align="right">
					<font color="#FFFFFF"><b>Closed in Version</b></font>
				</div>
			</td>
			<td valign="top" bgcolor="#cccccc">
				[Inline: $IV_SearchVersions,-SQL=$SQLSearchVersions]
				<select name="ClosedInVers_ID">
					<option value=""[If: (Var:'vClosedInVers_ID') == ''] selected[/If]></option>
					[Records]
					<option value="[Field:'Version_ID']"[If: (Var:'vClosedInVers_ID') == (Field:'Version_ID')] selected[/If]>[Field:'Version_Name']</option>
					[/Records]
		        </select>
		        [/Inline]
			</td>
		</tr>
[/If]
		<tr>
			<td width="120" bgcolor="#666666">
				<div align="right">
					<font color="#FFFFFF"><b>Title</b></font>[$svInputRequired]
				</div>
			</td>
			<td valign="top" bgcolor="#cccccc">
				<input type="text" name="Title" value="[Var:'vTitle']" size="45" maxlength="70"> 
			</td>
		</tr>

		<tr>
			<td width="120" bgcolor="#666666">
				<div align="right">
					<font color="#FFFFFF"><b>Description</b></font>[$svInputRequired]
				</div>
			</td>
			<td valign="top" bgcolor="#cccccc">
				<textarea name="Description" cols="45" rows="8">[Var:'vDescription']</textarea>
			</td>
		</tr>
		<tr>
			<td width="120" bgcolor="#666666">
				<div align="right">
					<font color="#FFFFFF"><b>Assigned to</b></font>
				</div>
			</td>
			<td valign="top" bgcolor="#cccccc">
<?Lassoscript
			// Display "Assigned to" as a popup if a superadmin or wgmanager, otherwise just output it
			If: (Var:'svUserPrivs_Priv') == 'Superadmin' || (Var:'svUserPrivs_Priv') == 'WGManager';
				Var:'SQLGetUsers' = 'SELECT User_ID, User_FName, User_LName FROM ' $svUsersTable ' WHERE User_Active = "Y" AND Usertypes_TypeID = "1" AND wg_id = "' $svUser_WGID '"';
				Inline: $IV_SearchUsers,-SQL=$SQLGetUsers;
?>					<select name="Assigned_To">
						<option value=""[If: (Var:'vAssigned_To') == ''] selected[/If]></option>
						[Records]
						<option value="[Field:'User_ID']"[If: (Var:'vAssigned_To') == (Field:'User_ID')] selected[/If]>[Field:'User_FName'] [Field:'User_LName']</option>
					[/Records]
			        </select>
<?Lassoscript
				/Inline;
			Else;
				If: (Var:'vAssigned_To') != '';
					GetUserName: -ID=$vAssigned_To;
				Else;
					'This issue is not currently assigned.';
				/If;
			/If;
?>			</td>
		</tr>
		<tr>
			<td width="120" bgcolor="#666666">
				<div align="right">
					<font color="#FFFFFF"><b>URL</b></font>[$svInputRequired]
				</div>
			</td>
			<td valign="top" bgcolor="#cccccc">
				<input type="text" name="URL" value="[Var:'vURL']" size="45" maxlength="255"> 
			</td>
		</tr>
		<tr>
			<td width="120" bgcolor="#666666">
				<div align="right">
					<font color="#FFFFFF"><b>Severity</b></font>[$svInputRequired]
				</div>
			</td>
			<td valign="top" bgcolor="#cccccc">
				[Var:'SQLSearchSeverity' = 'SELECT * FROM ' $svSeverityTable ' WHERE wg_id = "' $svUser_WGID '" ORDER BY Severity_Name']
				[Inline: $IV_SearchSeverity,-SQL=$SQLSearchSeverity]
				<select name="Severity_ID">
					<option value=""[If: (Var:'vSeverity_ID') == ''] selected[/If]></option>
					[Records]
					<option value="[Field:'Severity_ID']"[If: (Var:'vSeverity_ID') == (Field:'Severity_ID')] selected[/If]>[Field:'Severity_Name']</option>
					[/Records]
		        </select>
		        [/Inline]
			</td>
		</tr>
		<tr>
			<td width="120" bgcolor="#666666">
				<div align="right">
					<font color="#FFFFFF"><b>Priority</b></font>[$svInputRequired]
				</div>
			</td>
			<td valign="top" bgcolor="#cccccc">
				[Var:'SQLSearchPriority' = 'SELECT * FROM ' $svPriorityTable ' WHERE wg_id = "' $svUser_WGID '"']
				[Inline: $IV_SearchPriority,-SQL=$SQLSearchPriority]
				<select name="Priority_ID">
					<option value=""[If: (Var:'vPriority_ID') == ''] selected[/If]></option>
					[Records]
					<option value="[Field:'Priority_ID']"[If: (Var:'vPriority_ID') == (Field:'Priority_ID')] selected[/If]>[Field:'Priority_Name']</option>
					[/Records]
		        </select>
		        [/Inline]
			</td>
		</tr>
		<tr>
			<td width="120" bgcolor="#666666">
				<div align="right">
					<font color="#FFFFFF"><b>Status</b></font>[$svInputRequired]
				</div>
			</td>
			<td valign="top" bgcolor="#cccccc">
				[Var:'SQLSearchStatus' = 'SELECT * FROM ' $svStatusTable ' WHERE wg_id = "' $svUser_WGID '" ORDER BY Status_Name']
				[Inline: $IV_SearchStatus,-SQL=$SQLSearchStatus]
				<select name="Status_ID">
					<option value=""[If: (Var:'vStatus_ID') == ''] selected[/If]></option>
					[Records]
					<option value="[Field:'Status_ID']"[If: (Var:'vStatus_ID') == (Field:'Status_ID')] selected[/If]>[Field:'Status_Name']</option>
					[/Records]
		        </select>
		        [/Inline]
			</td>
		</tr>
<?Lassoscript
// If Add page, do not display "Resolution"
If: !((Response_Filepath) >> 'bugs_add.lasso');
?>
		<tr>
			<td width="120" bgcolor="#666666">
				<div align="right">
					<font color="#FFFFFF"><b>Resolution</b></font>
				</div>
			</td>
			<td valign="top" bgcolor="#cccccc">
				[Var:'SQLSearcResolutions' = 'SELECT * FROM ' $svResolutionsTable ' WHERE wg_id = "' $svUser_WGID '" ORDER BY Resolution_Name']
				[Inline: $IV_SearchResolutions,-SQL=$SQLSearcResolutions]
				<select name="Resolution_ID">
					<option value=""[If: (Var:'vResolution_ID') == ''] selected[/If]></option>
					[Records]
					<option value="[Field:'Resolution_ID']"[If: (Var:'vResolution_ID') == (Field:'Resolution_ID')] selected[/If]>[Field:'Resolution_Name']</option>
					[/Records]
		        </select>
		        [/Inline]
			</td>
		</tr>
[/If]		<tr>
			<td width="120" bgcolor="#666666">
				<div align="right">
					<font color="#FFFFFF"><b>Browser</b></font>[$svInputRequired]
				</div>
			</td>
			<td valign="top" bgcolor="#cccccc">
				[Var:'SQLSearchBrowsers' = 'SELECT * FROM ' $svBrowsersTable ' WHERE wg_id = "' $svUser_WGID '" ORDER BY browser_name']
				[Inline: $IV_SearchBrowsers,-SQL=$SQLSearchBrowsers]
				<select name="Browser_ID">
					<option value=""[If: (Var:'vBrowser_ID') == ''] selected[/If]></option>
					[Records]
					<option value="[Field:'Browser_ID']"[If: (Var:'vBrowser_ID') == (Field:'Browser_ID')] selected[/If]>[Field:'Browser_Name']</option>
					[/Records]
		        </select>
		        [/Inline]
			</td>
		</tr>
		<tr>
			<td width="120" bgcolor="#666666">
				<div align="right">
					<font color="#FFFFFF"><b>Operating&nbsp;System</b></font>[$svInputRequired]
				</div>
			</td>
			<td valign="top" bgcolor="#cccccc">
				[Var:'SQLSearchOS' = 'SELECT * FROM ' $svOSTable ' WHERE wg_id = "' $svUser_WGID '" ORDER BY os_name']
				[Inline: $IV_SearchOS,-SQL=$SQLSearchOS]
				<select name="OS_ID">
					<option value=""[If: (Var:'vOS_ID') == ''] selected[/If]></option>
					[Records]
					<option value="[Field:'OS_ID']"[If: (Var:'vOS_ID') == (Field:'OS_ID')] selected[/If]>[Field:'OS_Name']</option>
					[/Records]
		        </select>
		        [/Inline]
			</td>
		</tr>

		<tr>
			<td colspan="2" bgcolor="#666666">
				<div align="center">
<?Lassoscript
// If Edit page, add a hidden field to show check if page is submit
// Also add a hidden field with the User_ID
If: (Response_Filepath) >> 'bugs_editrecord.lasso';
				'\t\t\t\t<input type="hidden" name="Process" value="Y">\n';
				'\t\t\t\t<input type="hidden" name="BugID" value="'($vBug_ID)'">\n';
				'\t\t\t\t<input type="hidden" name="Project_ID" value="'($vProject_ID)'">\n';
				'\t\t\t\t<input type="submit" name="Action" value="Update">\n';
				'\t\t\t\t<input type="submit" name="Action" value="Delete" onClick="return confirmDelete()">\n';
Else;
				'\t\t\t\t<input type="submit" name="Action" value="Add">\n';
/If; ?>				</div>
			</td>
		</tr>
	</table>
</form>
<?Lassoscript
// Add a Bug Comment form
If: (Response_Filepath) !>> 'bugs_add.lasso';
?>
<form action="bugs_addresponse.lasso" method="post">
	<table border="0" cellpadding="5" width="520">
		<tr>
			<td width="120" bgcolor="#666666">
				<div align="right">
					<font color="#FFFFFF"><b>Comment</b></font>
				</div>
			</td>
			<td valign="top" bgcolor="#cccccc">
				<textarea name="Comment_Text" cols="45" rows="8">[Var:'vComment_Text']</textarea>
			</td>
		</tr>
		<tr>
			<td colspan="2" bgcolor="#666666">
				<div align="center">
					<input type="hidden" name="Process" value="Y">
					<input type="hidden" name="Bug_ID" value="[$vBug_ID]">
					<input type="hidden" name="Created_By" value="[$svUser_ID]">
					<input type="submit" name="Action" value="Add Comment">
				</div>
			</td>
		</tr>
	</table>
</form>

<?Lassoscript
// Attachments form
?>

<form enctype="multipart/form-data" action="bugs_addresponse.lasso" method="post">
	<table border="0" cellpadding="5" width="520">
		<tr>
			<td colspan="2" bgcolor="#666666" class="tablehead_10_white">Attachments</td>
		</tr>
			<tr> 
				<td width="120" bgcolor="#666666">
					<div align="right">
						<font color="#FFFFFF"><b>Attachment to Upload</b></font>
					</div>
				</td>
				<td valign="top" bgcolor="#cccccc">
					<input name="one" type="file">
				</td>
			</tr>
		<tr>
			<td colspan="2" bgcolor="#666666">
				<div align="center">
					<input type="hidden" name="Process" value="Y">
					<input type="hidden" name="Bug_ID" value="[$vBug_ID]">
					<input type="hidden" name="Created_By" value="[$svUser_ID]">
					<input type="submit" name="Action" value="Upload">
				</div>
			</td>
		</tr>
	</table>
</form>
[/If]
<table width="541" border="0" cellspacing="0" cellpadding="4">
<?Lassoscript
// Get the Attachments
Var:'vSQLGetAttachments' = 'SELECT * FROM ' $svSiteDatabase '.' $svAttachmentsTable '
	WHERE Bug_ID = "' $vBug_ID '"';

Inline: $IV_SearchAttachments, -SQL=$vSQLGetAttachments;

	Records;
		Var:'vAttach_Filename' = Field:'Attach_Filename';
		Var:'vAttach_CreatedBy' = Field:'Attach_CreatedBy';
		// Get username
		Inline: $IV_SearchUsers, 'User_ID' = $vAttach_CreatedBy;
			Var:'vCreatedByName' = (Field:'User_FName') ' ' (Field:'User_LName');
		/Inline;
?>	<tr class="singletext">
		<td width="120" valign="top">
			<p align="center">
				<a href="[Var:'svULpathImageLarge'][Var:'vAttach_Filename']" target="_blank"><img src="[Var:'svULpathImageThumb'][Var:'vAttach_Filename']" hspace="5" border="0"></a><br>[Var:'vAttach_Filename']<br>
			Uploaded by [Var:'vCreatedByName']<br>
			on [Field:'DateCreated']<br>
		</td>
	</tr>
	[/Records]
</table>
[/Inline] 
